local googleSignIn = require "plugin.googleSignIn"
local json = require("json")

local widget = require("widget")

-- debug keystore
-- use package org.ideategames.Samarkand with androiddebugkey from debug.keystore
-- debug SHA1 00:85:F2:62:A2:91:F0:D1:CE:9E:E9:FB:CD:1D:50:E7:82:6D:BE:9D
local CIDSD = "709195245465-0mnjadv6viu526a1a70vth3eah90jo0a.apps.googleusercontent.com"

googleSignIn.init({
ios={
    clientId = "888888888888-aewjiejgoiejgoiejgoerigjeoijg.apps.googleusercontent.com"
},
android={
    scopes= {"https://www.googleapis.com/auth/userinfo.email"},
    -- clientId = "652763858765-hq7huph5a5to4m39gqsoo7cn0ih3bd3d.apps.googleusercontent.com"
    clientId = CIDSD
}
})
googleSignIn.silentSignIn(function (e)
  if (e.isError) then
  	print(e.error)
  else
   print("you are signed in")
 end
end)

local bg = display.newRect( display.contentCenterX, display.contentCenterY, display.actualContentWidth, display.actualContentHeight )
bg:setFillColor( 0,0,1 )

local title = display.newText( "Google Sign In", display.contentCenterX, 40, native.systemFontBold ,30)


function googleListener(event)
    if (event.isError == true) then
        native.showAlert("Error Sign In", event.error, {"Ok"})
    elseif(event.status == "cancelled") then
        native.showAlert("Sign In Cancelled", json.encode(event), {"Ok"})
    elseif(event.status == "signed in") then
        native.showAlert("Signed In", json.encode(event), {"Ok"})
    elseif(event.status == "signed out") then
        native.showAlert("Signed Out", json.encode(event), {"Ok"})
    else
    	native.showAlert("unknown problem",json.encode(event), {"OK"})
    end
end

function signIn_onEvent(event)
	if(event.phase == "ended")then
		googleSignIn.signIn(googleListener)
	end
end

local signIn = widget.newButton( {
	label = "Sign In",
	fontSize = 20,
	labelColor = { default={ 1, 1, 1 }, over={ 0, 0, 0, 0.5 } },
	x = display.contentCenterX,
	y = display.contentCenterY,
	onEvent = signIn_onEvent
} )

function signOut_onEvent(event)
	if(event.phase == "ended")then
        googleSignIn.disconnect(googleListener)
        googleSignIn.signOut(googleListener)
	end
end

local signOut = widget.newButton( {
	label = "Sign Out/Disconnect",
	fontSize = 20,
	labelColor = { default={ 1, 1, 1 }, over={ 0, 0, 0, 0.5 } },
	x = display.contentCenterX,
	y = display.contentCenterY+100,
	onEvent = signOut_onEvent
} )
