#########################################
#
# utils.py
#
#
# basic utilities for Maze game
# and model for future utilities module
#
# more like a blackboard, really
#
#########################################
from direct.gui.DirectGui import *
import re
import sys

# these values are only for initialization because each import creates its own version
numRows = 3
numCols = 3
numWalls = numRows*numCols*4
topics = ["Museum","Europe_1340-1519","Art","Movies","Science","Literature","Western_Composers","Quotes"]
topic = "Museum"
levels = [2,3,5]
level = 0
numWrong = levels[level]
walls = {"N":0,"E":1,"S":2,"W":3}
rooms = ["00","01","02","10","11","12","20","21","22"]
roomOrder = ["00","01","10","02","11","20","12","21","22"]

skip = {"Museum":[],"Art":[],"Movies":[],"Science":[],"Literature":["agent"],"Europe_1340-1519":[],"Western_Composers":[],"Quotes":[]}

print("platform: "+str(sys.platform))
isHTML5 = sys.platform=="emscripten"
if isHTML5:
	import emscripten
else:
	import requests


transf = {"actor":"agent","who":"agent",\
	"number":"date","count":"date",\
	"objects":"clues"
}

def plur(num):
	ret = "s"
	if num==1:
		ret = ""
	return ret

def cleanImageName(iname):
	fname = iname.replace(" ","_").replace(".JPG",".jpg").replace(".png",".jpg").replace(".jpeg",".jpg").replace('.gif','.jpg')
	if fname.find(".jpg")<0 and fname.find(".png")<0:
		fname = fname + ".jpg"
	return fname

def getValidDoors(roomid):
	# doors are N,E,S,W order
	# print("utils received roomid: "+str(roomid)+":"+roomid[0:1])
	r = int(roomid[0:1])
	c = int(roomid[1])

	ret = []
	if r>0:
		# N door is ok
		ret.append(0)
	if c<(numCols-1):
		ret.append(1)
	if r<(numRows-1):
		# S is ok
		ret.append(2)
	if c>0:
		ret.append(3)
	return ret


def isDoorValid(roomid,dnum):
	return dnum in getValidDoors(roomid)


def getNextRoom(roomid,dnum):
	adders = [[-1,0],[0,1],[1,0],[0,-1]]
	r = int(roomid[0:1])
	c = int(roomid[1])
	print("getting next room: "+str(roomid)+":"+str(dnum)+":"+str(r+adders[int(dnum)][0])+str(c+adders[int(dnum)][1]))
	return 	str(r+adders[int(dnum)][0])+str(c+adders[int(dnum)][1])


def roomid2Display(roomid):
	r = int(roomid[0:1])+1
	c = int(roomid[1:2])+1
	# print("converted room: "+roomid+":"+str(r)+str(c))
	return str(r)+str(c)


def createButton(text,hPos,verticalPos,relief,eventArgs):
	ea = ""
	if len(eventArgs)>1:
		ea = eventArgs[1]
	btn=DirectButton(
		text=text,
		scale=0.07,
		pos=(hPos,0,verticalPos),
		command=eventArgs[0],
		extraArgs=ea,
		relief=relief,
		# frameColor=(0,0,0,1),
		rolloverSound=None,
		clickSound=None)
	return btn

def PPLmessage(txt):
	OnscreenText(text=txt, pos=(0,0),
	    scale=0.07, fg=(1, 0.5, 0.5, 1))

def getAttrTx(attr):
	ret = attr
	if attr in transf:
		ret = transf[attr]
	return ret

def extrDate(txt):
	tmp = re.findall(r'[-]?[\d]+',txt)
	if len(tmp)<1:
		tmp = ["2000"]
	print("extracted date: "+txt+":"+str(tmp[0]))
	return int(tmp[0])


# def onprogress(handle, progress):
# 	pass

def fetchListener(handle,rettext):
    print("Download failed with status code "+str(rettext))

callBackSignal = None
def onload(handle, file):
    # Download is finished.
    # texture = loader.load_texture(file)
    # print(texture)
    # card.set_texture(texture)
    print("loaded")
    messenger.send(callBackSignal,[file])


def onprogress(handle, progress):
    text = f"{progress} % downloading..."
    print(text)

def onerror(handle, code):
    text.text = f"Download failed with status code {code}."
    print(text.text)


# def httpFetch(url,fname,callBack,listener=fetchListener):
def httpFetch(url,fname,cbsignal,listener=fetchListener):
	callBackSignal = cbsignal
	if isHTML5:
		print("fetching: "+str(url))
		# handle = emscripten.async_wget(url, fname, onload=callBack, onerror=onerror, onprogress=onprogress)
		handle = emscripten.async_wget(url, fname, onload=onload, onerror=onerror, onprogress=onprogress)
	else:
		tmpdat = requests.get(url)
		if tmpdat.status_code != 200:
			fetchListener(fname,tmpdat.reason)
		else:
			print("received: "+str(tmpdat.encoding))
			if tmpdat.encoding:
				# callBack(tmpdat)
				messenger.send(callBackSignal,[tmpdat])
			else:
				# callBack(tmpdat.content)
				messenger.send(callBackSignal,[tmpdat.content])
